// Minimalistischer Host fr das Reinladen eines DelphiAutoServer-Objekts
// in die running object table (ROT). Dieses Objekt ist aus der Sicht
// von DelphiComAutoServTest.exe dann ein out-of-process-Server.

unit CSComServHostU;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, CSServerLib_TLB, StdCtrls, ActiveX;

type
  TCSComServHostForm = class(TForm)
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  public
    CT:  CSServer;  // interface
    ROTCookie: Integer;
  end;

var
  CSComServHostForm: TCSComServHostForm;

implementation

{$R *.dfm}

procedure TCSComServHostForm.FormCreate(Sender: TObject);
begin
  // Damit die Suche von CSComServTest nicht im Designer
  // von Delphi hngenbleibt - manuelle nderung es Titels
  Caption := Caption + ' - Active';

  CT := CoCSServer.Create;
  RegisterActiveObject(CT, CLASS_CSServer, ACTIVEOBJECT_WEAK, ROTCookie);
  CoLockObjectExternal(CT, true, true);
end;


procedure TCSComServHostForm.FormDestroy(Sender: TObject);
begin
  CoLockObjectExternal(CT, false, true);
  RevokeActiveObject(ROTCookie, nil);
  CoDisconnectObject(CT, 0);
end;

end.
